	include	mmclock.mac
	title	MM58167A date routines -- Copyright 1990 Wales

; ======================================================================
;
; Date routines for the MM58167A clock/calendar.
; (C) Copyright 1990 Richard B. Wales.  All Rights Reserved.
;
; Global variables:
;
;	None.
;
; Global routines:
;
;	GetDate
;		Reads the date from the real-time clock.
;
;	SetDate
;		Sets the date in the real-time clock.

; ======================================================================
;
; Global symbols.

	public	GetDate, SetDate

; ======================================================================
;
; XLAT table for converting BCD to binary (in TIME.ASM).

	extrn	bcd2bin:byte

; ======================================================================
;
; XLAT table for converting a month into a number of days.
; Since we need the total number of days since the date was last reset
; to be no more than 255, this table goes only up to August.

mon2day	db	-1, 30, 58, 89, 119, 150, 180, 211

; ======================================================================
;
; GetDate
;
;	Read the date info from the clock.
;
;	Arguments:
;
;		DX	Should be set to the initial I/O port address
;			for the clock.
;
;	Returned values:
;
;		CX	Date, represented as a 16-bit unsigned integer giving
;			the number of days since 1 January 1980.
;		DX	Number of days since the date was last set.
;
;	Note:
;		No effort is made to detect clock rollover while reading
;		the date.  This task is performed by "ClkToBuf".

GetDate	proc	near

	; Set up DS now, so that it will be ready for XLAT'ing later.
	; Since INIT_DS uses AX, we could not keep the pseudo-date in
	; AX if we deferred INIT_DS to just before DS was needed.
	INIT_DS

	; Read the pseudo-date (month/day from clock) and the long-count
	; date (4th and 5th bytes of clock RAM).  We get the pseudo-date
	; last because we need to play with it using several XLAT's.
	add	dx, 11			; skip to 4th/5th bytes of RAM
	INWR	cx			; long-count date (save in CX)
	sub	dx, 5			; skip to 7th/8th bytes of counter
	INWR	ax			; day and month (save in AX)

	; Convert everything from BCD to straight binary.
	; Note that we are accepting months only through August, in order
	; to ensure that the extra day count will be less than 256.
	mov	bx, offset bcd2bin
	XLATCKZ	ax, ax, 8, 31, bad_read

	; Translate the month into a number of days, add in the extra days,
	; and add the total to the long-count date.  This gives us the current
	; date (taking into account the time that has elapsed since the date
	; was last set).
	mov	bx, offset mon2day - 1
	xlat				; month -> # of days
	add	al, ah			; add in extra days
	xor	ah, ah
	add     cx, ax			; add month/day to long count
	mov	dx, ax			; return # days since date set too
	ret

bad_read:
	; If the date info is bogus, return 1 January 1980 (0 days).
	xor	cx, cx
	xor	dx, dx
	ret

GetDate	endp

; ======================================================================
;
; SetDate
;
;	Write the time-of-day info to the clock.
;
;	Arguments:
;
;		CX	Long-count date (number of days since 1/1/80).
;		DX	Should be set to the initial I/O port address
;			for the clock.
;
;	Returned values:
;
;		None.
;
;	Note:
;
;		No effort is made to detect clock rollover while setting
;		the date, since care is taken to call this routine only
;		in situations where midnight cannot occur during its
;		execution.

SetDate	proc	near

	add	dx, 6			; start with pseudo-date
	mov	ax, 0101h		; set pseudo-date
	OUTWR	ax			; pseudo-date (January 1)
	add	dx, 5			; date in 4th/5th bytes of RAM
	OUTWR	cx			; long-count date
	ret

SetDate	endp

code	ends

	end